/*******************************************************}
{                                                       }
{       RichView                                        }
{       Demo: drawing RVF fields in TDBGrid             }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************/
/*
Warning 1: RichView does not support loading text and paragraph styles
  from RVF under C++Builder 1, so this demo will not work properly in C++Builder 1
Warning 2: This demo uses a hack to change row heighs. It will cause glitches
  in drawing edit buttons in older versions of C++Builder
*/


//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma link "RVReport"
#pragma link "PtblRV"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  // Initializing RVReportHelper's properties
  RVReportHelper1->RichView->Style = RVStyle1;
  RVReportHelper1->RichView->Options << rvoTagsArePChars;
  // Allowing editing RVF fields
  for (int i = 0; i<DBGrid1->Columns->Count; i++)
    if (IsRVFField(DBGrid1->Columns->Items[i]->Field))
      DBGrid1->Columns->Items[i]->ButtonStyle = cbsEllipsis;
  DefRowHeight =((TDrawGrid*)DBGrid1)->DefaultRowHeight;
  SetRowHeight();
}
//---------------------------------------------------------------------------
void TfrmMain::SetRowHeight()
{
  // A hack to change DBGrid row heights. Is it possible without hacks?
  ((TDrawGrid*)DBGrid1)->DefaultRowHeight = 100;
  ((TDrawGrid*)DBGrid1)->RowHeights[0] = DefRowHeight;
}
//---------------------------------------------------------------------------
void MakeSelected(TRVReportHelper* rvh)
{
  for (int i=0; i<rvh->RichView->Style->TextStyles->Count; i++)
    rvh->RichView->Style->TextStyles->Items[i]->Color = clHighlightText;
  rvh->RichView->Color = clHighlight;
}
//---------------------------------------------------------------------------
// Drawing RVF field on Canvas at Rect using rvh.
void DrawRVFField(TBlobField* field, TCanvas* Canvas, TRect Rect,
  TRVReportHelper* rvh, bool Selected)
{
  try
  {
   rvh->RichView->Clear();
   rvh->RichView->Color = clWindow;

   TMemoryStream*Stream = new TMemoryStream;
   field->SaveToStream(Stream);
   Stream->Position = 0;
   rvh->RichView->LoadRVFFromStream(Stream);
   delete Stream;

   Graphics::TBitmap*bmp = new Graphics::TBitmap;
   bmp->Width = Rect.Right-Rect.Left;
   bmp->Height = Rect.Bottom-Rect.Top;
   rvh->Init(bmp->Canvas, bmp->Width);
   rvh->FormatNextPage(1000);
   if (Selected)
     MakeSelected(rvh);
   if (rvh->PagesCount>0)
     rvh->DrawPage(1, bmp->Canvas, true, bmp->Height);
   Canvas->Draw(Rect.Left, Rect.Top, bmp);
   delete bmp;
  }
  catch(...)
  {
  }
}
//---------------------------------------------------------------------------
// Drawing DBGrid RVF cell
void __fastcall TfrmMain::DBGrid1DrawColumnCell(TObject *Sender,
	const TRect &Rect, int DataCol, TColumn *Column, TGridDrawState State)
{
  if (IsRVFField(Column->Field))
    DrawRVFField((TBlobField*)(Column->Field), DBGrid1->Canvas, Rect,
      RVReportHelper1, State.Contains(gdSelected));
}
//---------------------------------------------------------------------------
// Editing
void __fastcall TfrmMain::DBGrid1EditButtonClick(TObject *Sender)
{
  if (!IsRVFField(DBGrid1->SelectedField))
    return;
  TMemoryStream* Stream = new TMemoryStream;
   ((TBlobField*)(DBGrid1->SelectedField))->SaveToStream(Stream);
   Stream->Position = 0;
   frmEdit->RichViewEdit1->LoadRVFFromStream(Stream);
   frmEdit->RichViewEdit1->Format();
   delete Stream;
  frmEdit->ActiveControl = frmEdit->RichViewEdit1;
  if (frmEdit->ShowModal()==mrOk)
  {
    Table1->Edit();
    TMemoryStream*Stream = new TMemoryStream;
    frmEdit->RichViewEdit1->SaveRVFToStream(Stream, false);
    Stream->Position = 0;
    ((TBlobField*)(DBGrid1->SelectedField))->LoadFromStream(Stream);
    delete Stream;
  }
}
//---------------------------------------------------------------------------
// Is this field a RVF field?
bool TfrmMain::IsRVFField(TField* Field)
{
  return Field->FieldName=="Data";
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::CheckBox1Click(TObject *Sender)
{
  TDBGridOptions Options = DBGrid1->Options;
  if (CheckBox1->Checked)
    Options >> dgEditing;
  else
    Options << dgEditing;
  DBGrid1->Options = Options;
  SetRowHeight();
}
//---------------------------------------------------------------------------
